function setup()
{
	if (window.widget) {
		widget.onhide = onhide;
		widget.onshow = onshow;
	}
	createGenericButton(document.getElementById('done'), 'Back', hidePrefs);
	flipShown = false;
	onshow();
}

function onshow() {
    if (timerInterval == null) {
        timerInterval = setInterval("updateTime(true);", 1000);
    }
}

function onhide() {
    if (timerInterval != null) {
        clearInterval(timerInterval);
        timerInterval = null;
    }
}

function addCommas( comVal ) { 
      var sRegExp = new RegExp('(-?[0-9]+)([0-9]{3})');
      while(sRegExp.test(comVal)) { 
      comVal = comVal.replace(sRegExp, '$1,$2'); 
      } 
      return comVal; 
}

function sdCount () {
    var today = new Date();
    StartDay = new Date("january 1, 2005");
    timex = (today.getTime() - StartDay.getTime());
    sectimex = timex / 1000;
    secondsx = Math.floor(sectimex);
    rawins = Math.floor(secondsx / 13);
    rawins = rawins+''
    incidents = addCommas(rawins);
    dayStr = today.toLocaleString();
    return incidents;
}

function getCount() { 
    document.getElementById("bg").innerText = sdCount() + " times."; 
    setTimeout("getCount()", 13000); 
} 

window.onload = getCount; 

function goToUrl(url)
{
	if (window.widget)
	{
		widget.openURL(url);
	}
}

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");
       
	front.style.display="none";
	back.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);  

	document.getElementById('fliprollie').style.display = 'none';
}

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");
      
	back.style.display="none";
	front.style.display="block";

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);

	flipShown = false;
}

var flipShown = false;
var animation = {duration:500, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!flipShown)
	{
		// fade in the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
 
		var starttime = (new Date).getTime() - 13;
 
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 1.0;
		animate();
		flipShown = true;
	}
	
	e.stopPropagation();
	e.preventDefault();
}

function mouseexit (event)
{
	if (flipShown)
	{
		// fade out the info button
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}

		var starttime = (new Date).getTime() - 13;

		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
	
	e.stopPropagation();
	e.preventDefault();
}
function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
   

	T = limit_3(time-animation.starttime, 0, animation.duration);

	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}

	animation.firstElement.style.opacity = animation.now;
}
function limit_3 (a, b, c)
{
	return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
	return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
	document.getElementById('flip').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}
